% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xplode.R
\name{xplode}
\alias{xplode}
\title{Extract values from a fitted GLMM object}
\usage{
xplode(model, name.cont = NA, name.factor = NA, names.response = NA,
  define.pf = list(pf1 = list(intercept = 1, slope = 2)))
}
\arguments{
\item{model}{The GLMM fitted with \code{glmer}. An object of class
\code{"\linkS4class{merMod}"}.}

\item{name.cont}{A string providing the name of the continuous predictor,
as in the formula object of the fitted model}

\item{name.factor}{A string providing the name of name of the categorical
predictor, as in the formula object of the fitted model}

\item{names.response}{Optional. A string providing the name of name of the
response variable, as in the formula object of the fitted model}

\item{define.pf}{Optional. Specifies which parameter pertains to the intercept
and which to the slope in the formula object.}
}
\value{
An object of class \code{"\linkS4class{merMod}"} to be used with other
 \code{MixedPsy} functions.
}
\description{
Extract values from an object of class \code{"\linkS4class{merMod}"}
(more specifically, from an object of subclass \code{glmerMod}).
}
\details{
For simplicity, several \code{MixedPsy} functions take as input an
 object of class \code{xplode} instead of an object of class
 \code{"\linkS4class{merMod}"}. Most of these functions assume by default that
 the continuous predictor is entered first in the formula object. It is possible
 to use a different order, this requires to specify which parameter pertains to
 the intercept and which to the slope, by changing \code{define.pf}.
}
\examples{
library(lme4)
datafr = PsySimulate(nsubjects = 10)
mod1 = glmer(formula = cbind(Longer, Total - Longer) ~ X + (1 | Subject),
family = binomial(link = "probit"), data = datafr)
xplode.mod1 = xplode(model = mod1, name.cont = "X")
MixDelta(xplode.mod1)

}
\seealso{
\code{\link[lme4]{merMod-class}} and \code{\link[lme4]{glmer}} from package 
\code{\link[lme4]{lme4}} for objects of class ``\code{merMod}''.
\code{\link{MixDelta}}, \code{\link{MixTreatment}} for use of objects of class \code{xplode.obj}.
}
\keyword{GLMM}
