% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output_JAGS.R
\name{output_JAGS}
\alias{output_JAGS}
\title{Process mixing model output from JAGS}
\usage{
output_JAGS(jags.1, mix, source, output_options = list(summary_save = TRUE,
  summary_name = "summary_statistics", sup_post = FALSE, plot_post_save_pdf =
  TRUE, plot_post_name = "posterior_density", sup_pairs = FALSE,
  plot_pairs_save_pdf = TRUE, plot_pairs_name = "pairs_plot", sup_xy = TRUE,
  plot_xy_save_pdf = FALSE, plot_xy_name = "xy_plot", gelman = TRUE, heidel =
  FALSE, geweke = TRUE, diag_save = TRUE, diag_name = "diagnostics",
  indiv_effect = FALSE, plot_post_save_png = FALSE, plot_pairs_save_png = FALSE,
  plot_xy_save_png = FALSE))
}
\arguments{
\item{jags.1}{rjags model object, output from \code{\link{run_model}} function}

\item{mix}{output from \code{\link{load_mix_data}}}

\item{source}{output from \code{\link{load_source_data}}}

\item{output_options}{list containing options for plots and saving:
\itemize{
 \item \code{summary_save}: Save the summary statistics as a txt file?
 \item \code{summary_name}: Summary statistics file name (.txt will be appended)
 \item \code{sup_post}: Suppress posterior density plot output in R?
 \item \code{plot_post_save_pdf}: Save posterior density plots as pdfs?
 \item \code{plot_post_name}: Posterior plot file name(s) (.pdf/.png will be appended)
 \item \code{sup_pairs}: Suppress pairs plot output in R?
 \item \code{plot_pairs_save_pdf}: Save pairs plot as pdf?
 \item \code{plot_pairs_name}: Pairs plot file name (.pdf/.png will be appended)
 \item \code{sup_xy}: Suppress xy/trace plot output in R?
 \item \code{plot_xy_save_pdf}: Save xy/trace plot as pdf?
 \item \code{plot_xy_name}: XY/trace plot file name (.pdf/.png will be appended)
 \item \code{gelman}: Calculate Gelman-Rubin diagnostic test?
 \item \code{heidel}: Calculate Heidelberg-Welch diagnostic test?
 \item \code{geweke}: Calculate Geweke diagnostic test?
 \item \code{diag_save}: Save the diagnostics as a .txt file?
 \item \code{diag_name}: Diagnostics file name (.txt will be appended)
 \item \code{indiv_effect}: artifact, set to FALSE
 \item \code{plot_post_save_png}: Save posterior density plots as pngs?
 \item \code{plot_pairs_save_png}: Save pairs plot as png?
 \item \code{plot_xy_save_png}: Save xy/trace plot as png?
}}
}
\description{
\code{output_JAGS} processes the mixing model output, prints and saves (in the
working directory):
\itemize{
 \item diagnostics
 \item summary statistics
 \item posterior density plots
 \item pairs plot
 \item trace/XY plots
}
}

