% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClusterAlgo.R, R/ClusterAlgoPredict.R,
%   R/ClusterInit.R, R/ClusterStrategy.R, R/IClusterModel.R, R/global.R,
%   R/ClusterCategorical.R, R/ClusterDiagGaussian.R, R/ClusterGamma.R,
%   R/ClusterMixedData.R, R/ClusterPoisson.R, R/IClusterPredict.R,
%   R/ClusterPredict.R, R/LearnAlgo.R, R/kmm.R, R/kmmMixedData.R
\docType{methods}
\name{print,ClusterAlgo-method}
\alias{print,ClusterAlgo-method}
\alias{print}
\alias{print-algo,ClusterAlgo-method}
\alias{print,ClusterAlgoPredict-method}
\alias{print-algo,ClusterAlgoPredict-method}
\alias{print,ClusterInit-method}
\alias{print-init,ClusterInit,ClusterInit-method}
\alias{print,ClusterStrategy-method}
\alias{print-strategy,ClusterStrategy-method}
\alias{print,IClusterComponent-method}
\alias{print,IClusterModel-method}
\alias{print,ClusterCategoricalComponent-method}
\alias{print,ClusterCategorical-method}
\alias{print,ClusterDiagGaussianComponent-method}
\alias{print,ClusterDiagGaussian-method}
\alias{print,ClusterGammaComponent-method}
\alias{print,ClusterGamma-method}
\alias{print,ClusterMixedDataModel-method}
\alias{print,ClusterPoissonComponent-method}
\alias{print,ClusterPoisson-method}
\alias{print,IClusterPredict-method}
\alias{print,ClusterPredict-method}
\alias{print,ClusterPredictMixedData-method}
\alias{print,LearnAlgo-method}
\alias{print-algo,LearnAlgo-method}
\alias{print,KmmComponent-method}
\alias{print,KmmModel-method}
\alias{print,KmmMixedDataModel-method}
\title{Print a MixAll S4 class to standard output.}
\usage{
\S4method{print}{ClusterAlgo}(x, ...)

\S4method{print}{ClusterAlgoPredict}(x, ...)

\S4method{print}{ClusterInit}(x, ...)

\S4method{print}{ClusterStrategy}(x, ...)

\S4method{print}{IClusterComponent}(x, ...)

\S4method{print}{IClusterModel}(x, ...)

\S4method{print}{ClusterCategoricalComponent}(x, k, ...)

\S4method{print}{ClusterCategorical}(x, ...)

\S4method{print}{ClusterDiagGaussianComponent}(x, k, ...)

\S4method{print}{ClusterDiagGaussian}(x, ...)

\S4method{print}{ClusterGammaComponent}(x, k, ...)

\S4method{print}{ClusterGamma}(x, ...)

\S4method{print}{ClusterMixedDataModel}(x, ...)

\S4method{print}{ClusterPoissonComponent}(x, k, ...)

\S4method{print}{ClusterPoisson}(x, ...)

\S4method{print}{IClusterPredict}(x, ...)

\S4method{print}{ClusterPredict}(x, ...)

\S4method{print}{ClusterPredictMixedData}(x, ...)

\S4method{print}{LearnAlgo}(x, ...)

\S4method{print}{KmmComponent}(x, k, ...)

\S4method{print}{KmmModel}(x, ...)

\S4method{print}{KmmMixedDataModel}(x, ...)
}
\arguments{
\item{x}{a MixAll object: a \code{\linkS4class{ClusterStrategy}},
a \code{\linkS4class{ClusterInit}} or a \code{\linkS4class{ClusterAlgo}}.}

\item{...}{further arguments passed to or from other methods}

\item{k}{the number of the cluster to print}
}
\value{
NULL. Prints to standard out.
}
\description{
Print a MixAll S4 class to standard output.
}
\examples{
  ## for cluster strategy
  strategy <- clusterStrategy()
  print(strategy)
  ## for cluster init
  init <- clusterInit()
  print(init)
  ## for cluster algo
  algo <- clusterAlgo()
  print(algo)

}
\seealso{
\code{\link{print}}
}
