% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MissCP.R
\name{first.step}
\alias{first.step}
\title{first.step}
\usage{
first.step(
  data_y,
  data_x,
  lambda1,
  lambda2,
  max.iteration = max.iteration,
  tol = tol,
  blocks,
  cv.index,
  fixed_index = NULL,
  nonfixed_index = NULL
)
}
\arguments{
\item{data_y}{input data matrix Y, with each column representing the time series component}

\item{data_x}{input data matrix X}

\item{lambda1}{tuning parmaeter lambda_1 for fused lasso}

\item{lambda2}{tuning parmaeter lambda_2 for fused lasso}

\item{max.iteration}{max number of iteration for the fused lasso}

\item{tol}{tolerance for the fused lasso}

\item{blocks}{the blocks}

\item{cv.index}{the index of time points for cross-validation}

\item{fixed_index}{index for linear regression model with only partial compoenents change.}

\item{nonfixed_index}{index for linear regression model with only partial compoenents change.}
}
\value{
A list object, which contains the followings
\describe{
  \item{jump.l2}{estimated jump size in L2 norm}
  \item{jump.l1}{estimated jump size in L1 norm}
  \item{pts.list}{estimated change points in the first step}
  \item{beta.full}{estimated parameters in the first step}
}
}
\description{
Perform the block fused lasso with thresholding to detect candidate break points.
}
