% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dada_phyloseq.R
\name{normalize_prop_pq}
\alias{normalize_prop_pq}
\title{Normalize OTU table using samples depth}
\usage{
normalize_prop_pq(physeq, base_log = 2, constante = 10000, digits = 4)
}
\arguments{
\item{physeq}{(required): a \code{\link{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{base_log}{(integer, default 2) the base for log-transformation. If
set to NULL or NA, no log-transformation is compute after normalization.}

\item{constante}{a constante to multiply the otu_table values}

\item{digits}{(default = 2) integer indicating the number of decimal places
to be used (see \code{?round} for more information)}
}
\value{
A new \code{\link{phyloseq-class}} object with otu_table count
normalize and log transformed (if base_log is an integer)
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function implement the method proposed by
McKnight et al. 2018 (\doi{doi:10.5061/dryad.tn8qs35})
}
\examples{
taxa_sums(data_fungi_mini)
data_f_norm <- normalize_prop_pq(data_fungi_mini)
taxa_sums(data_f_norm)
ggplot(data.frame(
  "norm" = scale(taxa_sums(data_f_norm)),
  "raw" = scale(taxa_sums(data_fungi_mini)),
  "name_otu" = taxa_names(data_f_norm)
)) +
  geom_point(aes(x = raw, y = norm))

data_f_norm <- normalize_prop_pq(data_fungi_mini, base_log = NULL)
}
\author{
Adrien Taudière
}
