% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/krona.R
\name{merge_krona}
\alias{merge_krona}
\title{Merge Krona files using \href{https://github.com/marbl/Krona/wiki}{KronaTools}.}
\usage{
merge_krona(files = NULL, output = "mergeKrona.html")
}
\arguments{
\item{files}{(required) path to html files to merged}

\item{output}{path to the output file}
}
\value{
A html file
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-maturing-blue" alt="lifecycle-maturing"></a>
}}


Need the installation of kronatools on the computer
(\href{https://github.com/marbl/Krona/wiki/Installing}{installation instruction}).

Function merge_krona allows merging multiple html files in one interactive
krona file

Note that you need to use the name args in \code{krona()} function before \code{merge_krona()}
in order to give good name to each krona pie in the output.
}
\details{
This function is mainly a wrapper of the work of others.
Please cite \href{https://github.com/marbl/Krona}{Krona} if
you use this function.
}
\examples{
\dontshow{if (tolower(Sys.info()[["sysname"]]) != "windows" && MiscMetabar::is_krona_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
data("GlobalPatterns", package = "phyloseq")
GA <- subset_taxa(GlobalPatterns, Phylum == "Acidobacteria")
krona(GA, "Number.of.sequences.html", name = "Nb_seq_GP_acidobacteria")
krona(GA, "Number.of.ASVs.html", nb_seq = FALSE, name = "Nb_asv_GP_acidobacteria")
merge_krona(c("Number.of.sequences.html", "Number.of.ASVs.html"), "mergeKrona.html")
unlink(c("Number.of.sequences.html", "Number.of.ASVs.html", "mergeKrona.html"))
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{krona}}
}
\author{
Adrien Taudière
}
