% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r_squared_poisson.R
\name{r_squared_poisson}
\alias{r_squared_poisson}
\title{Pseudo R-Squared regarding Poisson deviance}
\usage{
r_squared_poisson(actual, predicted, w = NULL, ...)
}
\arguments{
\item{actual}{Observed values.}

\item{predicted}{Predicted values.}

\item{w}{Optional case weights.}

\item{...}{Further arguments passed to \code{r_squared}.}
}
\value{
A numeric vector of length one.
}
\description{
Wrapper to \code{r_squared} with \code{deviance_function = deviance_poisson}.
}
\examples{
r_squared(0:2, c(0.1, 1, 2), w = rep(1, 3), deviance_function = deviance_poisson)
r_squared_poisson(0:2, c(0.1, 1, 2), w = rep(1, 3))
}
\seealso{
\code{\link{r_squared}}.
}
