% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvpp-class.R
\docType{class}
\name{cvpp-class}
\alias{cvpp-class}
\alias{cvpp}
\alias{show,cvpp-method}
\alias{summary,cvpp-method}
\alias{plot,cvpp,missing-method}
\alias{cvpp-method}
\title{The cvpp Class.}
\usage{
\S4method{show}{cvpp}(object)

\S4method{summary}{cvpp}(object)

\S4method{plot}{cvpp,missing}(x, y, ...)
}
\arguments{
\item{object}{A cvpp class object}

\item{x}{A cvpp class object}

\item{y}{missing}

\item{...}{The usual extra arguments to generic functions — see \code{\link[graphics]{plot}}, \code{\link[graphics]{plot.default}}}
}
\description{
Class of object returned by function \code{\link[MetabolicSurv]{CVPcaPls}}.
}
\section{Slots}{

\describe{
\item{\code{Results}}{A dataframe containg the estimated Hazard ratio of the test dataset and the training dataset}

\item{\code{Ncv}}{The number of cross validation performed}

\item{\code{Method}}{The dimesion reduction method used}

\item{\code{CVtrain}}{The training dataset indices matrix used for the cross validation}

\item{\code{CVtest}}{The test dataset indices matrix used for the cross validation}

\item{\code{Select}}{The number of metabolite used for the dimesion reduction method used}
}}

\examples{
## GENERATE SOME METABOLIC SURVIVAL DATA WITH PROGNOSTIC FACTORS
Data<-MSData(nPatients=100,nMet=150,Prop=0.5)

## USING THE FUNCTION
Result = CVPcaPls(Fold = 4, Survival = Data$Survival,
Mdata = t(Data$Mdata), Censor = Data$Censor, Reduce=TRUE,
Select=19, Prognostic= Data$Prognostic,Ncv=55,DR ="PLS")

## GET THE CLASS OF THE OBJECT
class(Result)     # A "cvpp" Class

##  METHOD THAT CAN BE USED FOR THE RESULT
show(Result)
summary(Result)
plot(Result)
}
\seealso{
\code{\link[MetabolicSurv]{CVPcaPls}}, \code{\link[MetabolicSurv]{SurvPcaClass}}, \code{\link[MetabolicSurv]{SurvPlsClass}}
}
\author{
Olajumoke Evangelina Owokotomo, \email{olajumoke.owokotomo@uhasselt.be}

Ziv Shkedy
}
