% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateSymmetry.R
\name{calculateSymmetry}
\alias{calculateSymmetry}
\title{Calculate Symmetry (of a Chromatographic Peak)}
\usage{
calculateSymmetry(peakData, pts)
}
\arguments{
\item{peakData}{A vector containing characteristic information about a chromatographic peak - including the retention time range}

\item{pts}{A 2D matrix containing the retention time and intensity values of a chromatographic peak}
}
\value{
The Symmetry of the peak (double)
}
\description{
Calculates the Symmetry of the integrated region of a chromatographic peak. The Symmetry is found by calcuating the correlation between
the left and right halves of the peak.
}
\details{
This function repurposed from TargetedMSQC. Toghi Eshghi, S., Auger, P., & Mathews, W. R. (2018). Quality assessment and
interference detection in targeted mass spectrometry data using machine learning. Clinical Proteomics, 15.
https://doi.org/10.1186/s12014-018-9209-x
}
\examples{
# Calculate Symmetry for a peak
data(ex_pts)
data(ex_peakData)
symmetry <- calculateSymmetry(peakData = ex_peakData, pts = ex_pts)

}
