% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_metalyzer-class.R
\docType{class}
\name{MetAlyzer-class}
\alias{MetAlyzer-class}
\alias{MetAlyzer}
\title{A S4 class to read and analyze 'MetIDQ' output}
\description{
A S4 class to read and analyze 'MetIDQ' output
}
\section{Slots}{

\describe{
\item{\code{file_path}}{A length-one character vector giving the file path}

\item{\code{sheet}}{A length-one numeric vector giving the sheet index}

\item{\code{metabolites}}{A character vector with all 630 measured metabolites and
optional 234 additional metabolism indicators}

\item{\code{raw_data}}{A data frame containing all raw measurements;
dimension: # samples x # metabolites}

\item{\code{quant_status}}{A data frame containing the quantification status of all
measurements; dimension: # samples x # metabolites}

\item{\code{meta_data}}{A data frame containing any meta data;
dimension: # samples x # meta variables}

\item{\code{plotting_data}}{A tibble data frame containing reshaped information of raw_data,
quant_status and meta_data for plotting with ggplot2}

\item{\code{.full_sheet}}{A matrix containing the un-sliced Excel sheet}

\item{\code{.data_ranges}}{A length-six numeric list with rows and columns
information for slicing}

\item{\code{.orig_metabolites}}{A character vector storing the unfiltered metabolites
vector}
}}

\examples{
fpath <- system.file("extdata", "example_data.xlsx", package = "MetAlyzer")
obj <- MetAlyzerDataset(file_path = fpath)
obj <- filterMetabolites(obj)
show(obj)
summariseQuantData(obj)

obj <- renameMetaData(obj, Method = Group)
obj <- filterMetaData(obj, column = Method, keep = 1:6)

\donttest{
obj <- createPlottingData(obj, Method, Tissue)
obj <- imputePlottingData(obj, Method, Metabolite)
obj <- transformPlottingData(obj)
obj <- performANOVA(obj, categorical = Method)
}
}
