% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distances.R
\name{distancesToMesh}
\alias{distancesToMesh}
\title{Distance to a mesh}
\usage{
distancesToMesh(mesh, points)
}
\arguments{
\item{mesh}{a mesh given either as a list containing (at least) the fields
\code{vertices} and \code{faces}, otherwise a \strong{rgl} mesh
(i.e. a \code{mesh3d} object)}

\item{points}{either one point given as a numeric vector or several points
given as a numeric matrix with three columns}
}
\value{
A numeric vector providing the distances between the given point(s)
  to the mesh.
}
\description{
Computes the distances from given points to a mesh.
}
\examples{
# cube example ####
library(MeshesOperations)
mesh <- rgl::cube3d()
points <- rbind(
  c(0, 0, 0),
  c(1, 1, 1)
)
distancesToMesh(mesh, points) # should be 1 and 0

# cyclide example ####
library(MeshesOperations)
a <- 100; c <- 30; mu <- 80
mesh <- cyclideMesh(a, c, mu, nu = 100L, nv = 100L)
O2 <- c(c, 0, 0)
# should be a - mu = 20 (see ?cyclideMesh):
distancesToMesh(mesh, O2)
}
