\name{get_mesh_metro}
\alias{get_mesh_metro}
\title{Distances between two 3D meshes}
\description{Calculate the distance maps between all pairs from a list of 3D meshes. Used for distance-based agreement measures such as the Hausdorff distance or the average surface distance.}
\usage{get_mesh_metro(x, chop=TRUE, ...)}
\arguments{
  \item{x}{\code{list} of observer/mesh objects as generated by \code{\link[MeshAgreement]{read_mesh}}.}
  \item{chop}{\code{logical}. Delete the components from output of \code{\link[Rvcg]{vcgMetro}} that will not be used later on.}
  \item{...}{Options passed to \code{\link[Rvcg]{vcgMetro}}.}
}
\details{Thin front-end for \code{\link[Rvcg]{vcgMetro}}. Use \code{\link[MeshAgreement]{get_mesh_metro_pair}} to process a single mesh pair. Calculating agreement measures for all pairs for a list of 3D meshes is done in \code{\link[MeshAgreement]{get_mesh_agree}}.}
\value{\code{list} of \code{list}s with the object returned by \code{\link[Rvcg]{vcgMetro}} together with the name of the comparison and a name for the structure.}
\seealso{
\code{\link[MeshAgreement]{data_heart_obsL}},
\code{\link[MeshAgreement]{read_mesh}},
\code{\link[MeshAgreement]{get_mesh_metro_pair}},
\code{\link[MeshAgreement]{get_mesh_agree}},
\code{\link[Rvcg]{vcgMetro}}
}
\references{\url{http://vcg.isti.cnr.it/vcglib/}}
\examples{
heartL <- mesh3dL_to_cgalMeshL(data_heart_obsL)
metroL <- get_mesh_metro(heartL, nSamples=500L, silent=TRUE)
# Hausdorff distance
get_HD_max <- function(x) {
    max(c(x$ForwardSampling$maxdist,
          x$BackwardSampling$maxdist))
}

Map(get_HD_max, metroL)
}
