\name{ClustRandExample1}
\alias{ClustRandExample1}
\title{
Simulation-based design of a cluster-randomized trial (normally distributed endpoint)
}
\description{
Consider a seamless Phase II/Phase III or Phase III trial with a normally distributed primary efficacy endpoint. A larger value of the endpoint corresponds to a more favorable outcome. A single dose or regimen of an experimental treatment will be compared to a control. An adaptive design with two interim analyses will be employed in the trial (the first interim analysis may correspond to the end of the Phase II portion of the trial). The following decision rules will be applied at the interim looks:
\itemize{
	\item Futility stopping rule will be applied at the first interim analysis (IA1). The trial may be stopped due to futility if a significant treatment effect is unlikely to be established at the final analysis (FA), i.e., the predicted probability of success (conditional power) is very low at this interim analysis.
    \item Sample size re-estimation rule will be applied at the second interim analysis (IA2). The total number of patients in the trial will be increased to boost the probability of success if the predicted probability of success (conditional power) is lower than expected at this interim analysis.
} 
The following design parameters will be assumed:
\itemize{
    \item A balanced design with 120 enrolled patients per arm will be utilized.
    \item The patient dropout rate is equal to 5\%, i.e., 5\% of the patients are expected to be lost to follow up by the end of the treatment period.
    \item The information fractions at IA1 and IA2 are set to 40\% and 60\%, i.e., the first and second interim looks will be taken after 40\% and 60\% of the patients complete the treatment period or drop out of the trial before completing the treatment period. 
}
In addition, the following decision rules will be considered at the two interim analyses:
\itemize{
    \item The futility threshold at IA1 is set to 10\%, i.e., the trial will be terminated for futility if conditional power does not exceed 10\%.
    \item The promising interval at IA2 ranges from 50\% to 90\%, i.e., the sample size in the trial will be increased if conditional power is greater than 50\% and less than 90\%.
    \item The target conditional power at IA2 is set to 90\%, i.e., the sample size will be increased to ensure conditional power of 90\% up a pre-defined cap. The maximum increase is equal to 30\% of the original sample size.
}
Finally, the mean effects in the control and treatment arms are assumed to be equal to 0 and 0.3, respectively, with a common standard deviation of 1.

Key operating characteristics of this adaptive design will be evaluated using the \code{\link{ClustRand}} function with 10,000 simulation runs. To invoke this function, a list of all design and decision rule parameters (\code{parameters}) needs to be created as shown below. A comprehensive simulation report can be generated by calling the \code{\link{GenerateReport}} function and a graphical user interface can be launched using the \code{\link{ClustRandApp}} function.
}
\arguments{No arguments}
\value{No return value}
\seealso{
  \code{\link{ClustRand}}, \code{\link{ClustRandExample2}}
}
\examples{
# List of all parameters
parameters = list()

# Endpoint type
parameters$endpoint_type = "Normal"

# Direction of favorable outcome
parameters$direction = "Lower"

# Number of completers in the trial arms (control, multiple treatments)
parameters$sample_size = c(100, 100)

# Cluster scheme
parameters$cluster_scheme = "Fixed"

# Vector of cluster sizes in the control arm
parameters$control_cluster_size = rep(10, 10)

# Vector of cluster sizes in the treatment arm
parameters$treatment_cluster_size = rep(10, 10)

# Mean in the control arm 
parameters$control_mean = 1

# Intra-cluster correlation coefficient in the control arm 
parameters$control_icc = 0.6

# Between-cluster standard deviation in the control arm 
parameters$control_between_cluster_sd = 1.2

# Mean in the treatment arm
parameters$treatment_mean = 0.3

# Intra-cluster correlation coefficient in the treatment arm
parameters$treatment_icc = 0.6

# Between-cluster standard deviation in the treatment arm 
parameters$treatment_between_cluster_sd = 1.2

# Data analysis method (generalized estimating equations (GEE) 
# or generalized linear mixed effects model (GLMEM))
parameters$method_type = "GEE"

# One-sided alpha level
parameters$alpha = 0.025

# Number of simulations
parameters$nsims = 10

# Number of cores for parallel calculations
parameters$ncores = 1

# Compute descriptive statistics (arm-specific effects, ICC, cluster sizes) for each simulation run
parameters$descriptive_statistics = TRUE

# Run simulations to compute operating characteristics
results = ClustRand(parameters)

# Generate a simulation report (remove tempfile)
GenerateReport(results, 
              tempfile("ClustRand Normally distributed endpoint.docx", fileext=".docx"))
}