% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VP.R
\name{VP}
\alias{VP}
\title{Actual vapor pressure}
\usage{
VP(Tmax = NULL, Tmin = NULL, Rhmax = NULL, Rhmin = NULL,
  interval = "day", Tmean = NULL, Rhmean = NULL, Twet = NULL,
  Tdry = NULL, apsy = NULL, P = NULL)
}
\arguments{
\item{Tmax}{maximum temperature during 24-hour period (for daily values)}

\item{Tmin}{minimum temperature during 24-hour period  (for daily values)}

\item{Rhmax}{maximum relative humidity [precent] (for daily values)}

\item{Rhmin}{minimum relative humidity [precent] (for daily values)}

\item{interval}{hour, day, week or month}

\item{Tmean}{Mean air temperature [degreeC] (for periods shorter 1 day)}

\item{Rhmean}{Mean air humidity [percent] (for periods shorter 1 day or if Rhmax and Rhmin are missing)}

\item{Twet}{wet bulb temperature (for calculation with psychrometric data)}

\item{Tdry}{dry bulb tamperature (for calculation with psychrometric data)}

\item{apsy}{coefficient depending on the type of ventilation of the wet bulb [kPa/(degreeC)] (for calculation with psychrometric data)}

\item{P}{atmospheric pressure [kPa]}
}
\description{
Calculate actual vapour pressure [kPa] either from psychrometric data or from relative humidity data.
}
\details{
\describe{\item{x:}{
must be provided as.numeric (1-366) or as a common date-time object (e.g, POSIXct, POSIXlt or Date objects).
All formats for which is.timepoint from the lubridate package returns TRUE can be used}}
\describe{\item{interval:}{
- use hour for periods <= one hour \cr
- for day, week or month the same equations are used}}
}
\note{
eq. 17 of reference (Determination of actual vapour pressure from relative maximum and minimum humidity)

eq. 15 of reference (Actual vapour pressure derived from psychrometric data) (see \code{\link{psyc_cons}})

eq. 19 of reference (used in the absence of RHmax and RHmin)

eq. 54 of reference (for periods shorter than a day)
}
\examples{
VP(Tmax = 25, Tmin = 18, Rhmax = 82, Rhmin = 54)
VP(Tmax = 25, Tmin = 18, Rhmean = 68)
}
\references{
Allen, R. G., Pereira, L. S., Raes, D., & Smith, M. (1998). Crop evapotranspiration-Guidelines for computing crop water requirements-FAO Irrigation and drainage paper 56. FAO, Rome, 300(9).
}
\seealso{
\code{\link{e0}}, \code{\link{satVP}}
}
