% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/getUSCounty.R
\name{getUSCounty}
\alias{getUSCounty}
\title{Return US County Name at Specified Locations}
\usage{
getUSCounty(lon, lat, dataset = "USCensusCounties", stateCodes = NULL,
  allData = FALSE)
}
\arguments{
\item{lon}{vector of longitudes in decimal degrees}

\item{lat}{vector of latitudes in decimal degrees}

\item{dataset}{name of spatial dataset to use -- defaults to 'USCensusCounties'}

\item{stateCodes}{vector of stateCodes used to limit the search -- defaults to \code{NULL}}

\item{allData}{logical specifying whether a full dataframe should be returned}
}
\value{
vector of counties
}
\description{
Uses spatial comparison to determine which county polygons the
    locations fall into and returns the county name strings for those polygons.

    Specification of \code{stateCodes} limits spatial searching to the specified states
    and greatly improves performance.

    If \code{allData=TRUE} additional data is returned.
}
\examples{
\dontrun{
lon <- seq(-140,-90)
lat <- seq(20,70)
getCountry(lon,lat)
}
}
\references{
\url{http://www.naturalearthdata.com/downloads/10m-cultural-vectors/}
}
\seealso{
getSpatialData
}
\keyword{spatial}

