% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_leaflet.R
\name{table_leaflet}
\alias{table_leaflet}
\title{Leaflet interactive map for known locations}
\usage{
table_leaflet(
  locationTbl = NULL,
  maptype = "terrain",
  extraVars = NULL,
  locationOnly = FALSE,
  ...
)
}
\arguments{
\item{locationTbl}{Tibble of known locations.}

\item{maptype}{Optional name of leaflet ProviderTiles to use, e.g. \code{terrain}.}

\item{extraVars}{Character vector of addition \code{locationTbl} column names
to be shown in leaflet popups.}

\item{locationOnly}{Logical specifying whether to check for all standard
columns.}

\item{...}{Additional arguments passed to \code{leaflet::addCircleMarker()}.}
}
\value{
A leaflet "plot" object which, if not assigned, is rendered in
Rstudio's 'Viewer' tab.
}
\description{
This function creates interactive maps that will be displayed in
  RStudio's 'Viewer' tab.
}
\details{
The \code{maptype} argument is mapped onto leaflet "ProviderTile"
  names. Current mappings include:
\enumerate{
\item{"roadmap"}{ -- "OpenStreetMap"}
\item{"satellite"}{ -- "Esri.WorldImagery"}
\item{"terrain"}{ -- "Esri.WorldTopoMap"}
\item{"toner"}{ -- "Stamen.Toner"}
}

If a character string not listed above is provided, it will be used as the
underlying map tile if available. See
\url{https://leaflet-extras.github.io/leaflet-providers/} for a list of
"provider tiles" to use as the background map.
}
