% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_smd_comparison.R
\name{plot_smd}
\alias{plot_smd}
\title{Draw a dot-line plot that compares the SMD change before and after matching}
\usage{
plot_smd(smd_data = NULL)
}
\arguments{
\item{smd_data}{a data frame derived from \code{\link{compute_smd}}}
}
\value{
Return a list of relevant data, code, and plot
}
\description{
This function accepts the data set from compute_smd() and draws a dot-line
plot to compare the SMD change before and after matching. This function
differs from plot(summary(data, standardize = T) in MatchIt package in the
following aspects: (1) it uses the original SMD values, rather than the
absolute SMD values; (2) overall SMD line is colored in blue; (3) increased
SMD line is colored in brick red; (4) decreased SMD line is colored in gray.
This function depends on ggplot2. If users are not satisfied with the plot,
it can be revised with ggplot2. Relevant data and codes are stored in the
returned list.
}
\examples{
m_out <- MatchIt::matchit(treat ~ re74 + re75 + age + educ + hispan +
 black, data = MatchIt::lalonde, method = "nearest")
opt_smd <- compute_smd(m_out, sd = "treatment")
plot_smd_data <- plot_smd(opt_smd)
}
\seealso{
plot_ps_qq()
}
\keyword{SMD}
\keyword{plot}
