% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkMWRfrecom.R
\name{checkMWRfrecom}
\alias{checkMWRfrecom}
\title{Check data quality objective frequency and completeness data}
\usage{
checkMWRfrecom(frecomdat, warn = TRUE)
}
\arguments{
\item{frecomdat}{input data frame}

\item{warn}{logical to return warnings to the console (default)}
}
\value{
\code{frecomdat} is returned as is if no errors are found, otherwise an informative error message is returned prompting the user to make the required correction to the raw data before proceeding.
}
\description{
Check data quality objective frequency and completeness data
}
\details{
This function is used internally within \code{\link{readMWRfrecom}} to run several checks on the input data for frequency and completeness and conformance to WQX requirements

The following checks are made:
\itemize{
\item Column name spelling: Should be the following: Parameter, Field Duplicate, Lab Duplicate, Field Blank, Lab Blank, Spike/Check Accuracy, \% Completeness
\item Columns present: All columns from the previous check should be present
\item Non-numeric values: Values entered in columns other than the first should be numeric
\item Values outside of 0 - 100: Values entered in columns other than the first should not be outside of 0 and 100
\item Parameter: Should match parameter names in the \code{Simple Parameter} or \code{WQX Parameter} columns of the \code{\link{paramsMWR}} data
\item Empty columns: Columns with all missing or NA values will return a warning
}
}
\examples{
library(dplyr)

frecompth <- system.file('extdata/ExampleDQOFrequencyCompleteness.xlsx', 
     package = 'MassWateR')

frecomdat <- suppressMessages(readxl::read_excel(frecompth, 
      skip = 1, na = c('NA', 'na', ''), 
      col_types = c('text', 'numeric', 'numeric', 'numeric', 'numeric', 'numeric', 'numeric')
    )) \%>\% 
    rename(`\% Completeness` = `...7`)
    
checkMWRfrecom(frecomdat)
}
