% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilMWRlimits.R
\name{utilMWRlimits}
\alias{utilMWRlimits}
\title{Fill results data as BDL or AQL with appropriate values}
\usage{
utilMWRlimits(resdat, param, accdat, warn = TRUE)
}
\arguments{
\item{resdat}{results data as returned by \code{\link{readMWRresults}}}

\item{param}{character string to first filter results by a parameter in \code{"Characteristic Name"}}

\item{accdat}{\code{data.frame} for data quality objectives file for accuracy as returned by \code{\link{readMWRacc}}}

\item{warn}{logical to return warnings to the console (default)}
}
\value{
\code{resdat} with any entries in \code{"Result Value"} as \code{"BDL"} or \code{"AQL"} replaced with appropriate values in the \code{"Quantitation Limit"} column, if present, otherwise the \code{"MDL"} or \code{"UQL"} columns from the data quality objectives file for accuracy are used.  Values as \code{"BDL"} use one half of the appropriate limit.
}
\description{
Fill results data as BDL or AQL with appropriate values
}
\examples{
# results file path
respth <- system.file('extdata/ExampleResults.xlsx', package = 'MassWateR')

# results data
resdat <- readMWRresults(respth)

# accuracy path
accpth <- system.file('extdata/ExampleDQOAccuracy.xlsx', 
     package = 'MassWateR')

# accuracy data
accdat <- readMWRacc(accpth)

# apply to total phosphorus
utilMWRlimits(resdat, accdat, param = 'TP')

# apply to E.coli
utilMWRlimits(resdat, accdat, param = 'E.coli')
}
