% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilMWRconfint.R
\name{utilMWRconfint}
\alias{utilMWRconfint}
\title{Summarize a results data frame for means and confidence intervals}
\usage{
utilMWRconfint(dat, logscl)
}
\arguments{
\item{dat}{input data frame}

\item{logscl}{logical indicating if summaries are log10-scale or not}
}
\value{
A summarized data frame
}
\description{
Summarize a results data frame for means and confidence intervals
}
\details{
This function is used internally for the analysis functions
}
\examples{
library(dplyr)

# results data path
respth <- system.file('extdata/ExampleResults.xlsx', package = 'MassWateR')

# results data
resdat <- readMWRresults(respth)

#' # accuracy path
accpth <- system.file('extdata/ExampleDQOAccuracy.xlsx', 
     package = 'MassWateR')

# accuracy data
accdat <- readMWRacc(accpth)

# fill BDL, AQL
resdat <- utilMWRlimits(resdat = resdat, accdat = accdat, param = "DO")

dat <- resdat \%>\% 
  group_by(`Monitoring Location ID`)
  
utilMWRconfint(dat, logscl = FALSE)
utilMWRconfint(dat, logscl = TRUE)
}
