% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R, R/metrics_factor.R,
%   R/metrics_numeric.R
\name{metrics}
\alias{metrics}
\alias{accuracy}
\alias{auc}
\alias{brier}
\alias{cindex}
\alias{cross_entropy}
\alias{f_score}
\alias{fnr}
\alias{fpr}
\alias{kappa2}
\alias{npv}
\alias{ppv}
\alias{pr_auc}
\alias{precision}
\alias{recall}
\alias{roc_auc}
\alias{roc_index}
\alias{rpp}
\alias{sensitivity}
\alias{specificity}
\alias{tnr}
\alias{tpr}
\alias{weighted_kappa2}
\alias{gini}
\alias{mae}
\alias{mse}
\alias{msle}
\alias{r2}
\alias{rmse}
\alias{rmsle}
\title{Performance Metrics}
\usage{
accuracy(observed, predicted = NULL,
  cutoff = MachineShop::settings("cutoff"), ...)

auc(observed, predicted = NULL, metrics = c(MachineShop::tpr,
  MachineShop::fpr), stat = MachineShop::settings("stat.Curves"), ...)

brier(observed, predicted = NULL, ...)

cindex(observed, predicted = NULL, ...)

cross_entropy(observed, predicted = NULL, ...)

f_score(observed, predicted = NULL,
  cutoff = MachineShop::settings("cutoff"), beta = 1, ...)

fnr(observed, predicted = NULL,
  cutoff = MachineShop::settings("cutoff"), ...)

fpr(observed, predicted = NULL,
  cutoff = MachineShop::settings("cutoff"), ...)

kappa2(observed, predicted = NULL,
  cutoff = MachineShop::settings("cutoff"), ...)

npv(observed, predicted = NULL,
  cutoff = MachineShop::settings("cutoff"), ...)

ppv(observed, predicted = NULL,
  cutoff = MachineShop::settings("cutoff"), ...)

pr_auc(observed, predicted = NULL, ...)

precision(observed, predicted = NULL,
  cutoff = MachineShop::settings("cutoff"), ...)

recall(observed, predicted = NULL,
  cutoff = MachineShop::settings("cutoff"), ...)

roc_auc(observed, predicted = NULL, ...)

roc_index(observed, predicted = NULL,
  cutoff = MachineShop::settings("cutoff"), f = function(sensitivity,
  specificity) (sensitivity + specificity)/2, ...)

rpp(observed, predicted = NULL,
  cutoff = MachineShop::settings("cutoff"), ...)

sensitivity(observed, predicted = NULL,
  cutoff = MachineShop::settings("cutoff"), ...)

specificity(observed, predicted = NULL,
  cutoff = MachineShop::settings("cutoff"), ...)

tnr(observed, predicted = NULL,
  cutoff = MachineShop::settings("cutoff"), ...)

tpr(observed, predicted = NULL,
  cutoff = MachineShop::settings("cutoff"), ...)

weighted_kappa2(observed, predicted = NULL, power = 1, ...)

gini(observed, predicted = NULL, ...)

mae(observed, predicted = NULL, ...)

mse(observed, predicted = NULL, ...)

msle(observed, predicted = NULL, ...)

r2(observed, predicted = NULL, dist = NULL, ...)

rmse(observed, predicted = NULL, ...)

rmsle(observed, predicted = NULL, ...)
}
\arguments{
\item{observed}{\link[=response]{observed responses}; or
\link{confusion}, \link[=performance_curve]{performance curve}, or
\link{resample} result containing observed and predicted responses.}

\item{predicted}{\link[=predict]{predicted responses} if not contained in
\code{observed}.}

\item{cutoff}{numeric (0, 1) threshold above which binary factor
probabilities are classified as events and below which survival
probabilities are classified.}

\item{...}{arguments passed to or from other methods.}

\item{metrics}{list of two performance metrics for the calculation [default:
ROC metrics].}

\item{stat}{function or character string naming a function to compute a
summary statistic at each cutoff value of resampled metrics in performance
curves, or \code{NULL} for resample-specific metrics.}

\item{beta}{relative importance of recall to precision in the calculation of
\code{f_score} [default: F1 score].}

\item{f}{function to calculate a desired sensitivity-specificity tradeoff.}

\item{power}{power to which positional distances of off-diagonals from the
main diagonal in confusion matrices are raised to calculate
\code{weighted_kappa2}.}

\item{dist}{character string specifying a distribution with which to estimate
the survival mean in the total sum of square component of \code{r2}.
Possible values are \code{"empirical"} for the Kaplan-Meier estimator,
\code{"exponential"}, \code{"extreme"}, \code{"gaussian"},
\code{"loggaussian"}, \code{"logistic"}, \code{"loglogistic"},
\code{"lognormal"}, \code{"rayleigh"}, \code{"t"}, or \code{"weibull"}
(default).}
}
\description{
Compute measures of agreement between observed and predicted responses.
}
\seealso{
\code{\link{metricinfo}}, \code{\link{performance}}
}
