% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{GetLeastContribution}
\alias{GetLeastContribution}
\title{Get least HV contribution}
\usage{
GetLeastContribution(populationObjective, reference = NULL,
  method = "exact")
}
\arguments{
\item{populationObjective}{The objective value of the corresponding individual}

\item{reference}{The reference point for computing HV}

\item{method}{the HV computation method}
}
\value{
The HV contribution value of the least contributor.
}
\description{
Get the hypervolume (HV) contribution of the individual with least HV contribution.
}
\examples{
 \donttest{
nObjective <- 5 # the number of objectives
nPoint <- 10 # the number of points that will form the hypervolume
objective <- matrix(stats::runif(nObjective*nPoint), nrow = nObjective, ncol = nPoint)
GetHypervolume(objective,,"exact") # no reference supplied

reference <- rep(2,nObjective) # create a reference point at (2,2,2,2,2)
GetLeastContribution(objective,reference,"exact")
}
}
