% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corr.compute.R
\name{corr.compute}
\alias{corr.compute}
\title{A Function for Computing a Vector of Pearson Correlation Coefficients}
\usage{
corr.compute(exp.mat, cn.mat, gene.annot, method = "pearson", digits = 5,
  alternative = "greater")
}
\arguments{
\item{exp.mat}{A matrix of gene-level expression data (rows = genes, columns = samples).  Missing values are not permitted.}

\item{cn.mat}{A matrix of gene-level DNA copy number data (rows = genes, columns = samples).  Both genes and samples should
appear in the same order as exp.mat.  Missing values are not permitted.}

\item{gene.annot}{A three-column matrix containing gene position information.  Column 1 = chromosome number written in 
the form 'chr1' (note that chrX and chrY should be written chr23 and chr24), Column 2 = position (in base pairs), Column 3 = cytoband.
Genes should appear in the same order as exp.mat and cn.mat.}

\item{method}{A character string (either "pearson" or "spearman") specifying the method used to calculate the correlation coefficient
(default = "pearson").}

\item{digits}{Used with signif() to specify the number of significant digits (default = 5).}

\item{alternative}{A character string ("greater" or "less") that specifies the direction of the alternative hypothesis, 
either rho > 0 or rho < 0 (default = "greater").}
}
\value{
Returns a eight-column matrix.  The first three columns are the same as gene.annot.  The fourth column contains
gene-specific Pearson or Spearman correlation coefficients based on the entries in each row of exp.mat and cn.mat, 
respectively (column name = "R").  The fifth column contains squared Pearson correlation coefficients (column name = "R^2").  
The sixth column contains t statistics corresponding to the correlation coefficients (column name = "tStat").  The
seventh column contains the right-tailed p-value based on the t statistic (column name = "pValue").  The eighth column
contains Benjamini-Hochberg q-values corresponding to the p-values.  Genes with constant gene expression
or DNA copy number are removed because they have zero variance.
}
\description{
This function computes Pearson correlation coefficients on a row-by-row basis for two numerical input matrices of the same size.
}
\examples{
corr.results = exp.mat = tcga.exp.convert(exp.mat)

 cn.mat = tcga.cn.convert(cn.mat)

 prepped.data = data.prep(exp.mat, cn.mat, gene.annot, sample.annot, log.exp = FALSE)

 corr.compute(prepped.data[["exp"]], prepped.data[["cn"]], prepped.data[["gene.annot"]])

}
