% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mv_outlier.R
\name{mv_outlier}
\alias{mv_outlier}
\title{Identify Multivariate Outliers via Robust Mahalanobis Distances}
\usage{
mv_outlier(
  data,
  outlier = TRUE,
  qqplot = TRUE,
  alpha = 0.05,
  method = c("quan", "adj"),
  label = TRUE,
  title = "Chi-Square Q-Q Plot"
)
}
\arguments{
\item{data}{A numeric matrix or data frame with observations in rows and at least two numeric columns.}

\item{outlier}{Logical; if \code{TRUE}, includes the Mahalanobis distance values and outlier classification in the output. 
If \code{FALSE}, suppresses this component. Default is \code{TRUE}.}

\item{qqplot}{Logical; if \code{TRUE}, a Chi-Square Q–Q plot is generated to visualize outlier detection. Default is \code{TRUE}.}

\item{alpha}{Numeric; significance level used for the adjusted cutoff method (only applies if \code{method = "adj"}). Default is \code{0.05}.}

\item{method}{Character string specifying the outlier detection method. Must be either \code{"quan"} (quantile-based cutoff)
or \code{"adj"} (adjusted cutoff via ARW). Default is \code{"quan"}.}

\item{label}{Logical; if \code{TRUE} and \code{qqplot = TRUE}, labels the detected outliers in the plot. Default is \code{TRUE}.}

\item{title}{Optional character string specifying the title for the Q–Q plot. Default is \code{"Chi-Square Q-Q Plot"}.}
}
\value{
A list containing the following components:
\code{outlier}, a data frame of Mahalanobis distances with observation IDs and outlier flags (if \code{outlier = TRUE});
\code{qq_outlier_plot}, a ggplot object of the Mahalanobis Q–Q plot (if \code{qqplot = TRUE});
and \code{newData}, a data frame of non-outlier observations.
}
\description{
Computes robust Mahalanobis distances for multivariate data using the Minimum Covariance Determinant (MCD)
estimator, flags outliers based on either a chi-square quantile cutoff or an adjusted cutoff using the
Atkinson–Riani–Welsh (ARW) method, and optionally generates a Mahalanobis Q–Q plot.
}
\examples{
\dontrun{
data <- iris[, 1:4]
res <- mv_outlier(data, method = "adj", alpha = 0.025)
res$outlier
res$qq_outlier_plot
head(res$newData)
}

}
