% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spmsDxnoFSS.R
\name{spmsDx_no_fss}
\alias{spmsDx_no_fss}
\title{Identification of secondary progressive multiple sclerosis without functional system scores and ambulation score}
\usage{
spmsDx_no_fss(
  visits,
  minEDSS = 4,
  tRelapse = 30,
  tProgression = 3 * 30.25,
  tRegression = 9 * 30.25,
  tRelProg = 6 * 30.25
)
}
\arguments{
\item{visits}{A dataframe consisting of 6 columns: ID, dateEDSS, EDSS, dateBlineVisit, bEDSS (baseline EDSS), daysPostRelapse (days since most recent relapse).}

\item{minEDSS}{Minimum EDSS score required to reach SPMS conversion.}

\item{tRelapse}{Minimum time in days since the most recent relapse to EDSS assessment.}

\item{tProgression}{SPMS confirmation period in days.}

\item{tRegression}{Confirmation period for EDSS improvement in days.}

\item{tRelProg}{Confirmation period (days) for re-baselining EDSS (after a relapse led to non-confirmed increase in EDSS).}
}
\value{
A data frame.
}
\description{
Identify conversion from relapsing-remitting multiple sclerosis (RRMS) to secondary progressive multiple sclerosis (SPMS), using the CORe definition without Functional System Scores (FSS) of Expanded Disability Status Scale (EDSS). The identification of SPMS is based on clinical visit records, each record including entries for patient code, visit date, EDSS score, and days since most recent relapse.
If a baseline EDSS score is not provided, this is determined as the first EDSS score recorded in the dataset, outside 30 days (the default) of a relapse.
Following a relapse, the first EDSS score recorded in the dataset outside 30 days (the default) of a relapse, becomes the new baseline EDSS score.
SPMS is sustained for the remainder of the follow-up, unless followed by two consecutive improvements in EDSS scores.
}
\examples{
data(SampleData)
output<-spmsDx_no_fss(SampleData)
}
\references{
Lorscheider J, et al. Brain 2016; 139 (9): 2395-2405.

Brown JW, et al. JAMA 2019; 321 (2): 175-87.

Lizak N, et al. JAMA Neurology 2020; 77 (11): 1398-407.
}
