% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{simuHMM}
\alias{simuHMM}
\title{Simulate Hidden Markov model with normally distributed errors}
\usage{
simuHMM(mdl_h0, burnin = 100L)
}
\arguments{
\item{mdl_h0}{List containing the following DGP parameters
\itemize{
  \item{\code{n}: }{Length of series.}
  \item{\code{k}: }{Number of regimes.}
  \item{\code{mu}: }{A (\code{k x q}) vector of means.}
  \item{\code{sigma}: }{A (\code{q x q}) covariance matrix.}
  \item{\code{q}: }{Number of series.}
  \item{\code{P}: }{A (\code{k x k}) transition matrix (columns must sum to one).}
  \item{\code{eps}: }{An optional (\code{T+burnin x q}) matrix with standard normal errors to be used. Errors will be generated if not provided.}
}}

\item{burnin}{Number of simulated observations to remove from beginning. Default is \code{100}.}
}
\value{
List with simulated series and its DGP parameters.
}
\description{
This function simulates a Hidden Markov Model process.
}
\examples{
set.seed(1234)

# ----- Univariate ----- #
# Define DGP 
mdl_hmm <- list(n     = 1000, 
                q     = 1,
                mu    = as.matrix(c(5,
                                   -2)),
                sigma = list(as.matrix(5.0),
                             as.matrix(7.0)),
                k     = 2,
                P     = rbind(c(0.90, 0.10),
                              c(0.10, 0.90)))

# Simulate process using simuHMM() function
y_hmm_simu <- simuHMM(mdl_hmm)

# ----- Multivariate ----- #
# Define DGP 
mdl_hmm <- list(n     = 1000, 
                q     = 2,
                mu    = rbind(c(5, -2),
                              c(10, 2)),
                sigma = list(rbind(c(5.0, 1.5),
                                   c(1.5, 1.0)),
                             rbind(c(7.0, 3.0),
                                   c(3.0, 2.0))),
                k     = 2,
                P     = rbind(c(0.90, 0.10),
                              c(0.10, 0.90)))

# Simulate process using simuHMM() function
y_hmm_simu <- simuHMM(mdl_hmm)

}
