% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{chpStat}
\alias{chpStat}
\title{Test statistic for CHP 2014 parameter stability test}
\usage{
chpStat(mdl, rho_b, ltmt, msvar)
}
\arguments{
\item{\code{mdl}}{List containing model attributes (see \code{\link{ARmdl}}).}

\item{\code{rho_b}}{Number determining bounds for distribution of \code{rh0} (i.e. \code{rho} ~ \code{[-rho_b,rho_b]}).}

\item{\code{ltmt}}{List containing derivatives output from \code{\link{chpDmat}}.}

\item{\code{msvar}}{Boolean indicator. If \code{TRUE}, there is a switch in variance. If \code{FALSE} only switch in mean is considered.}
}
\value{
A (\code{2 x 1}) vector with supTS test statistic as first element and expTS test-statistics as second element.
}
\description{
This function computes the supTS and expTS test-statistics 
proposed in CHP 2014.
}
\references{
Carrasco, Marine, Liang Hu, and Werner Ploberger. 2014. “Optimal 
test for Markov switching parameters.” \emph{Econometrica} 82 (2): 765–784.
}
\keyword{internal}
