% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SS2OM.R
\name{SS2OM}
\alias{SS2OM}
\title{Reads MLE estimates from Stock Synthesis file structure into an operating model using package r4ss.}
\usage{
SS2OM(SSdir, nsim = 48, proyears = 50, reps = 1, maxF = 3,
  seed = 1, Obs = DLMtool::Generic_Obs, Imp = DLMtool::Perfect_Imp,
  import_mov = TRUE, gender = 1,
  Name = "OM generated by SS2OM function",
  Source = "No source provided", Author = "No author provided", ...)
}
\arguments{
\item{SSdir}{A folder with Stock Synthesis input and output files in it.}

\item{nsim}{The number of simulations to take for parameters with uncertainty (for OM@cpars custom parameters).}

\item{proyears}{The number of projection years for MSE}

\item{reps}{The number of stochastic replicates within each simulation in the operating model.}

\item{maxF}{The maximum allowable F in the operating model.}

\item{seed}{The random seed for the operating model.}

\item{Obs}{The observation model (class Obs).}

\item{Imp}{The implementation model (class Imp).}

\item{import_mov}{Logical, whether to import movement matrix from the assessment.}

\item{gender}{An integer index for the sex for which life history values are importing (1 = female, 2 = male).}

\item{Name}{The name of the operating model}

\item{Source}{Reference to assessment documentation e.g. a url}

\item{Author}{Who did the assessment}

\item{...}{Arguments to pass to \link[r4ss]{SS_output}.}
}
\value{
An object of class OM.
}
\description{
A function that uses the file location of a fitted SS3 model including input files to population the
various slots of an operating model with MLE parameter estimates. The function mainly populates the Stock and Fleet portions
of the operating model; the user still needs to parameterize most of the observation and implementation portions of the operating model.
}
\details{
The function generally uses values from the terminal year of the assessment for most life history parameters (maturity, M, etc). This function
does detect time-varying growth in the assessment and uses annual length/weight-at-age for historical years.
Selectivity is derived from the F-at-age matrix.
}
\note{
Currently supports versions of r4ss on CRAN (v.1.24) and Github (v.1.34-35). Function may be incompatible with other versions of r4ss.
}
\seealso{
\link{SS2Data}
}
\author{
T. Carruthers and Q. Huynh
}
