% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeOfBlobs.R
\name{TINNIKdist}
\alias{TINNIKdist}
\title{Compute TINNIK distance from quartets and hypothesis test p-values}
\usage{
TINNIKdist(pTable, test = "T3", alpha = 0.05, beta = 0.05)
}
\arguments{
\item{pTable}{table of resolved quartet counts, as produced by
\code{quartetTableResolved}, with extra columns from
both star hypothesis test, and either cut or T3 hypothesis tests}

\item{test}{either "cut" or "T3"}

\item{alpha}{level for cut or T3 test}

\item{beta}{level for star test}
}
\value{
a distance table \code{output$dist} and
   a vector \code{output$Bquartets} with TRUE/FALSE entries indicating B-quartets
   ordered as rows of \code{pTable}.
}
\description{
Apply the B-quartet inference algorithm of \insertCite{ABMR22;textual}{MSCquartets}, \insertCite{ABMR24;textual}{MSCquartets} to
infer all B-quartets from results of hypothesis tests, and then compute an estimate of an intertaxon distance
fitting the topological tree of blobs of the species network.
}
\details{
This function assumes \code{pTable} has columns for taxa and resolved
quartet counts as originally produced by \code{quartetTable},
and hypothesis test results as produced by
\code{quartetStarTestInd}, and either \code{quartetTreeTestInd} for the \code{T3} test or \code{quartetCutTestInd}.
Rows must be present for every 4-taxon subset.
(Note: Of functions in this package, only \code{HolmBonferroni} might modify the row order from the required one.)

This function uses the Rcpp package for significant speed up in computation time.
}
\examples{
data(pTableYeastRokas)
out=TINNIKdist(pTableYeastRokas,test="T3",alpha=.05,beta=.05)

}
\references{
\insertRef{ABMR22}{MSCquartets}

\insertRef{ABMR24}{MSCquartets}
}
\seealso{
\code{\link{quartetTable},\link{quartetTableResolved},\link{quartetStarTest}},
\code{\link{quartetCutTest}}, \code{\link{quartetStarTestInd}}, \code{\link{quartetCutTestInd}}
}
