% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listFromLong.r
\name{listFromLong}
\alias{listFromLong}
\title{Convert Long Format to List Format}
\usage{
listFromLong(foo, unit.variable, time.variable, unit.names.variable = NULL,
  exclude.columns = NULL)
}
\arguments{
\item{foo}{A \code{data.frame} containing the data in "long" format.}

\item{unit.variable}{Either a numeric scalar with the column number (in 
\code{foo}) containing the units or a character scalar with the corresponding
column name in \code{foo}.}

\item{time.variable}{Either a numeric scalar with the column number (in 
\code{foo}) containing the times or a character scalar with the corresponding
column name in \code{foo}.}

\item{unit.names.variable}{Optional. If not \code{NULL}, either a numeric 
scalar with the column number (in \code{foo}) containing the unit names or 
a character scalar with  the corresponding column name in \code{foo}. Must
match with the units defined by \code{unit.variable} (if not \code{NULL}).}

\item{exclude.columns}{Optional (defaults to \code{NULL}). Numeric vector 
with column numbers of \code{foo} to be excluded from the conversion.}
}
\value{
A list of matrices with rows corresponding to the times and columns
corresponding to the unit (or unit names, respectively) for all columns of
\code{foo} which are neither excluded nor have a special role as time, unit,
or unit names variable.
}
\description{
\code{listFromLong} converts long to list format.
}
\details{
\code{listFromLong} is a convenience function to convert long format
(in a \code{\link[base]{data.frame}}, as used by package 'Synth') to list 
format, where data is stored as a list of matrices.

Most parameter names are named after their equivalents in the 
\code{\link[Synth]{dataprep}} function of package 'Synth'.
}
\examples{
if (require("Synth")) {
  data(basque)
  Basque <- listFromLong(basque, unit.variable="regionno", 
                         time.variable="year", 
                         unit.names.variable="regionname")
  names(Basque)
  head(Basque$gdpcap)
}
}
