% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mqmf_utils.r
\name{makelabel}
\alias{makelabel}
\title{makelabel generates a label from text and values}
\usage{
makelabel(txt, vect, sep = "_", sigdig = 3)
}
\arguments{
\item{txt}{the input text for the label}

\item{vect}{the series of values to be included in the label}

\item{sep}{the separator for the components; defaults to  _}

\item{sigdig}{how many significant digits for the values; default = 3}
}
\value{
a character string made up of text and values
}
\description{
It is common to want a label with text and a series of
    values. But paste and paste0 cycles the text and the values. To
    avoid this makelabel first combines the values as text and then
    adds the input text to the front of the values
}
\examples{
pars <- c(18.3319532,33.7935124,3.0378107,6.0194465,0.5815360,0.4270468)
makelabel("Cohort1",pars[c(1,3,5)],sep="__")
makelabel("Cohort1",pars[c(1,3,5)],sep="__",sigdig=4)
}
