% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_reqbands.R
\name{get_reqbands}
\alias{get_reqbands}
\title{Identify the MODIS original bands needed for a given processing run}
\usage{
get_reqbands(bands_indexes_matrix, indexes_bandsel, indexes_bandnames,
  quality_bandsel, quality_bandnames, out_prod_folder, file_prefix, yy,
  DOY, out_format, reprocess)
}
\arguments{
\item{bands_indexes_matrix}{\code{matrix} built by \code{set_bandind_matrix}}

\item{indexes_bandsel}{\code{integer 0/1 array} array of length equal to the number
of Spectral Indexes available for the product (standard + user-provided),
set to  1 for indexes to be processed.}

\item{indexes_bandnames}{\code{character array} Abbreviated Names of SIs available
for the selected product (used to build output file names of SIs).}

\item{quality_bandsel}{\code{integer 0|1 array} array of length equal to number
of available QIs, set to  1 for indexes to be processed.}

\item{quality_bandnames}{\code{character array} Abbreviated Names of Quality
Indicators available for the selected product (used to build output file
names of QIs).}

\item{out_prod_folder}{\code{character} Main folder where the MODIStsp processed
raster will be stored. Used to check if a given processed image already exists.}

\item{file_prefix}{File prefix corresponding to the MODIS product being
processed. Used to check if a given processed image already exists.}

\item{yy}{Year corresponding to the image being processed. Used to check if
a given processed image already exists.}

\item{DOY}{DOY corresponding to the image being processed. Used to check if
a given processed image already exists.. Used to check if a given processed image already exists.}

\item{out_format}{\code{character ["ENVI" | "GTiff"]} Desired output format.}

\item{reprocess}{\code{character ["Yes" | "No"]} If Yes, reprocess data for already
existing dates.}
}
\value{
req_bands_indexes
}
\description{
Helper function used in MODIStsp_process to identify which
MODIS hdf layers are required for the current process. The required layers
include all MODIS original layers selected by the user, plus all those
required to compute the Spectral Indexes and Quality Indicators selected
by the user
}
\author{
Lorenzo Busetto, phD (2017) \href{mailto:lbusett@gmail.com}{lbusett@gmail.com}
}
