% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_models.R
\name{compare_models}
\alias{compare_models}
\title{Model selection}
\usage{
compare_models(MLZ_model.list, figure = TRUE, color = NULL)
}
\arguments{
\item{MLZ_model.list}{A list containing objects of class \code{MLZ_model}, all from the same mortality
estimator and same data set.}

\item{figure}{If \code{TRUE}, produces a figure of model fits to the observed data.}

\item{color}{Optional vector of colors for the figure each representing a separate model
in \code{MLZ_model.list}. If \code{NULL}, colors from \code{\link[gplots]{rich.colors}}
will be used.}
}
\description{
Produces a matrix of AIC for model selection.
}
\examples{
data(Goosefish)
goose <- ML(Goosefish, ncp = 0)
goose1 <- ML(Goosefish, ncp = 1)
goose2 <- ML(Goosefish, ncp = 2, grid.search = TRUE, figure = FALSE)

compare_models(list(goose, goose1, goose2))

data(PRSnapper)
ssm <- MLmulti(PRSnapper, ncp = 1, model = "SSM")
msm1 <- MLmulti(PRSnapper, ncp = 1, model = "MSM1")
msm2 <- MLmulti(PRSnapper, ncp = 1, model = "MSM2")
msm3 <- MLmulti(PRSnapper, ncp = 1, model = "MSM3")

compare_models(list(ssm, msm1, msm2, msm3))

}
