% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catplot.R
\name{catplot}
\alias{catplot}
\title{Caterpillar plot}
\usage{
catplot(confint, ann = TRUE, grid = FALSE)
}
\arguments{
\item{confint}{an object containing the output from function
\code{\link{confint.index}}}

\item{ann}{default is TRUE. If set to false, suppresses the automatic
annotation of residuals on the plots with a confidence interval that does not
overlap with any other}

\item{grid}{arrange the plots in a grid? (Default is TRUE)}
}
\description{
Draws a series of caterpillar plots, showing the residuals from the
multilevel model at each level and the estimates of their confidence interval
}
\details{
A caterpillar plot is a visual way of looking at the variance of the
residuals at each level of a multilevel model. It can be used to see which
places are contributing most to the Index of Dissimilarity net of the
effects of other scales.

To aid the interpretability of the plots, the residuals are scaled by the
standard error of the residuals from the OLS estimate of the index.
Additionally, to avoid over-plotting only a maximum of 50 residuals are
shown on each plot. These are the 10 highest and lowest ranked residuals
and then a sample of 30 from the remaining residuals, chosen as the ones
with values that differ most from the residuals that precede them by ranking.
In this way, the plots aim to preserve the tails of the ranked distribution
as well as the most important break points inbetween.

When \code{ann = TRUE} (the default) some outliers are labelled and the
percentage of the total variance due to each level is included. These
will not add up to 100% because the base level is not presented.
\code{catplot} is a wrapper to \code{\link{plot.confintindex}}
}
\examples{
\dontrun{
data(aggdata)
index <- id(aggdata, vars = c("Bangladeshi", "WhiteBrit"),
levels = c("MSOA","LAD","RGN"))
ci <- confint(index)
catplot(ci, grid = TRUE)
# Plots for all levels above the base level
}
}
\seealso{
\code{\link{confint.index}} \code{\link{id}}
}
