% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_axes.R
\name{sum_up}
\alias{sum_up}
\title{Sum of multi-channel signal.}
\usage{
sum_up(df, axes = NULL)
}
\arguments{
\item{df}{dataframe. multi-channel signal, with the first column being the
timestamp in POSXct format.}

\item{axes}{numerical vector. Specify the column indices for each axis. When
this value is NULL, the function assumes the axes are starting from column
2 to the end. Default is \code{NULL}.}
}
\value{
dataframe. The transformed dataframe will have the same number of
  rows as input dataframe but only two columns, with the first being
  timestamps and second being the sum up values.
}
\description{
\code{sum_up} computes the sum up value for each sample (row) of a
multi-channel signal.
}
\details{
This function takes a dataframe of a multi-channel signal as input, and then
computes the sum of each row and returns a transformed dataframe with two
columns.
}
\section{How is it used in MIMS-unit algorithm?}{
 This function is used to
  combine MIMS-unit values on each axis into a single value after aggregating
  over each epoch using \code{\link{aggregate_for_mims}}.
}

\examples{
  # Use the first 10 rows of the sample data as an example
  df = sample_raw_accel_data[1:10,]
  df

  # By default, the function will assume columns starting from 2 to be axial
  # values.
  sum_up(df)

  # Or, you may specify the column indices yourself
  sum_up(df, axes=c(2,3,4))

  # Or, if you only want to consider x and y axes
  sum_up(df, axes=c(2,3))

  # Or, just return the chosen column
  sum_up(df, axes=c(2))

}
\seealso{
\code{\link{vector_magnitude}}

Other transformation functions: 
\code{\link{compute_orientation}()},
\code{\link{vector_magnitude}()}
}
\concept{transformation functions}
