% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MGLMgen.R, R/pdfln.R
\name{rdirmn}
\alias{rdirmn}
\alias{dirmn}
\alias{ddirmn}
\title{The Dirichlet Multinomial Distribution}
\usage{
rdirmn(n, size, alpha)

ddirmn(Y, alpha)
}
\arguments{
\item{n}{number of random vectors to generate.  When \code{size} is a scalar and \code{alpha} is a vector, 
must specify \code{n}.  When \code{size} is a vector and \code{alpha} is a matrix, \code{n} is optional.
The default value of \code{n} is the length of \code{size}. If given, \code{n} should be equal to 
the length of \code{size}.}

\item{size}{a number or vector specifying the total number of objects that are put
into d categories in the Dirichlet multinomial distribution.}

\item{alpha}{the parameter of the Dirichlet multinomial distribution. Can be a numerical positive vector or matrix.
For \code{ddirmn}, \code{alpha} has to match the size of \code{Y}. If \code{alpha} 
is a vector, it will be replicated \eqn{n} times to match the dimension of \code{Y}.

For \code{rdirmn}, if \code{alpha} is a vector, \code{size} must be a scalar, and all the random vectors will
be drawn from the same \code{alpha} and \code{size}.  
If \code{alpha} is a matrix, the number of rows should match the length of 
\code{size}, and each random vector 
will be drawn from the corresponding row of \code{alpha} and the corresponding
element in the \code{size} vector. See Details below.}

\item{Y}{The multivariate count matrix with dimensions \eqn{n \times d}{nxd}, where 
\eqn{n = 1,2, \ldots} is the number of observations and \eqn{d=2,3, \ldots} is the number of categories.}
}
\value{
For each count vector and each corresponding parameter vector
\eqn{\alpha}, the function \code{ddirmn} returns the value \eqn{\log(P(y|\alpha))}{logP(y|\alpha)}. 
When \code{Y} is a matrix of \eqn{n} rows, \code{ddirmn} returns a vector of length \eqn{n}.
 
\code{rdirmn} returns a \eqn{n\times d}{nxd} matrix of the generated random observations.
}
\description{
\code{ddirmn} computes the log of the Dirichlet multinomial probability mass function.
\code{rdirmn} generates Dirichlet multinomially distributed random number vectors.
}
\details{
When the multivariate count data exhibits over-dispersion, the traditional 
multinomial model is insufficient. Dirichlet multinomial distribution models the
probabilities of the categories by a Dirichlet distribution. 
Given the parameter vector \eqn{\alpha = (\alpha_1, \ldots, \alpha_d), \alpha_j>0  }, 
the probability mass of \eqn{d}-category count vector \eqn{Y=(y_1, \ldots, y_d)}, \eqn{d \ge 2} 
under Dirichlet multinomial distribution is
\deqn{
 P(y|\alpha) = C_{y_1, \ldots, y_d}^{m} \prod_{j=1}^{d} 
 \frac{\Gamma(\alpha_j+y_j)}{\Gamma(\alpha_j)}
 \frac{\Gamma(\sum_{j'=1}^d \alpha_{j'})}{\Gamma(\sum_{j'=1}^d \alpha_{j'} + \sum_{j'=1}^d y_{j'})},
 }{
 P(y|\alpha) =
 C_{y_1, \ldots, y_d}^{m} prod_{j=1}^d 
 {Gamma(\alpha_j+y_j)Gamma(sum_{j'=1}^d \alpha_j')} / {Gamma(\alpha_j)Gamma(sum_{j'=1}^d \alpha_j' + sum_{j'=1}^d y_j')},
 }
where \eqn{m=\sum_{j=1}^d y_j}{m = sum_{j=1}^d y_j}. Here, \eqn{C_k^n}, often read as "\eqn{n} choose \eqn{k}", 
refers the number of \eqn{k} combinations from a set of \eqn{n} elements.


The parameter \eqn{\alpha} can be a vector of length \eqn{d}, 
such as the results from the distribution fitting.
\eqn{\alpha} can also be a matrix with \eqn{n} rows, such as the inverse link  
calculated from the regression parameter estimate \eqn{exp(X\beta)}.
}
\examples{
m <- 20
alpha <- c(0.1, 0.2)
dm.Y <- rdirmn(n=10, m, alpha)	
pdfln <- ddirmn(dm.Y, alpha)
}
\keyword{distribution}
\keyword{models}
