% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FCP_TPA.R
\name{gcv}
\alias{gcv}
\title{Generalized cross-validation for the FCP-TPA algorithm}
\usage{
gcv(alpha, n, z, eta, lambda)
}
\arguments{
\item{alpha}{The current value of the smoothing parameter.}

\item{n}{The length of the dimension, for which the smoothing parameter is to
be optimized.}

\item{z}{A vector of length \code{n}. See Details.}

\item{eta}{A vector of length \code{n}. See Details.}

\item{lambda}{A vector of length \code{n}, containing the eigenvalues of the
penalty matrix corresponding the the current image direction.}
}
\value{
The value of the GCV criterion.
}
\description{
These function calculates the generalized cross-validation criterion for the 
smoothing parameters \eqn{\alpha_v} or \eqn{\alpha_w} that are used in the 
\code{\link{FCP_TPA}} algorithm. As the criterion is symmetric in \eqn{v} and
\eqn{w}, this function implements a generic criterion, which is called by 
\code{\link{findAlphaVopt}}, \code{\link{findAlphaWopt}} with the correct values.
}
\details{
The criterion can be evaluated in a numerically efficient way, adopting the ideas in Huang, Shen and Buja (2008) to three-ways tensors. TODO!
}
\references{
G. I. Allen, "Multi-way Functional Principal Components 
  Analysis", IEEE International Workshop on Computational Advances in 
  Multi-Sensor Adaptive Processing, 2013.
}
\seealso{
\code{\link{FCP_TPA}}
}
\keyword{internal}

