% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MESS-package.R
\docType{data}
\name{bdstat}
\alias{bdstat}
\title{Danish live births and deaths}
\format{
A data frame with 1356 observations on the following 4 variables.
\describe{ \item{year}{a numeric vector giving the month}
\item{month}{a numeric vector giving the year}
\item{births}{a numeric vector. The number of births for the given
month and year} \item{dead}{a numeric vector. The number of deaths
for the given month and year} }
}
\source{
Data were obtained from the StatBank from Danmarks Statistik, see
\url{http://www.statbank.dk}.
}
\description{
Monthly live births and deaths in Denmark from January 1901 to March 2013.
}
\examples{

data(bdstat)

plot(bdstat$year + bdstat$month/13, bdstat$birth, type="l")

# Create a table of births
# Remove year 2013 as it is incomplete
btable <- xtabs(births ~ year + month, data=bdstat, subset=(year<2013))

# Compute yearly birth frequencies per month
btable.freq <- prop.table(btable, margin=1)

}
\keyword{datasets}
