% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panel.R
\name{panel.r2}
\alias{panel.r2}
\title{Panel plot of R2 values for pairs}
\usage{
panel.r2(x, y, digits = 2, cex.cor, ...)
}
\arguments{
\item{x}{a numeric vector of x values}

\item{y}{a numeric vector of y values}

\item{digits}{a numeric value giving the number of digits to present}

\item{cex.cor}{scaling fator for the size of text}

\item{...}{extra options (not used at the moment)}
}
\description{
Prints the R2 with text size depending on the size of R2
}
\details{
This function is a slight modification of the panel.cor
function defined on the pairs help page. It calculated and
prints the squared correlation, R2, with text size depending
on the proportion of explained variation.
}
\examples{

pairs(~ Ozone + Temp + Wind + Solar.R, data=airquality,
      lower.panel=panel.smooth, upper.panel=panel.r2)

}
\author{
Claus Ekstrom \email{claus@rprimer.dk}
}
\references{
Ekstrom, CT (2011) \emph{The R Primer}.
}
\keyword{iplot}

