% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MECfda_simDataGen_fcReg.R
\name{MECfda_simDataGen_fcReg}
\alias{MECfda_simDataGen_fcReg}
\title{Simulation Data Generation: Scalar-on-function Regression}
\usage{
MECfda_simDataGen_fcReg(
  N = 100,
  distribution = c("Gaussian", "Bernoulli"),
  t_interval,
  t_points,
  n_t = 100,
  seed = 0
)
}
\arguments{
\item{N}{Sample size.}

\item{distribution}{Conditional distribution of response varaible given the covariate
(\eqn{Y_i|X_i(t),Z_i}).
There are two options: \code{'Gaussian'} and \code{'Bernoulli'}.}

\item{t_interval}{A 2-element vector, represents an interval,
means the domain of the functional covariate.
Default is \code{c(0,1)}, represent interval \eqn{[0,1]}.}

\item{t_points}{the measurement points of functional variables,
should be numeric vector.}

\item{n_t}{Number of measurement time points.
Overwritten if argument \code{t_points} is assigned.}

\item{seed}{Pseudo-random number generation seed.}
}
\value{
return a list with following elements.
   \item{Y}{An atomic vector of response variable}
   \item{Z}{A dataframe with a binary and a continuous scalar-valued covariate.}
   \item{FC}{A list of two 'functional_variable' class object.}
   \item{t_interval}{Same as in the input argument.}
   \item{t_points}{Sequence of the measurement (time) points.}
}
\description{
Generate data set for scalar-on-function regression
}
\examples{
dat_sim = MECfda_simDataGen_fcReg(100,"Bernoulli")
res = fcRegression(FC = dat_sim$FC, Y=dat_sim$Y, Z=dat_sim$Z,
                   basis.order = 3, basis.type = c('Fourier'),
                   family = binomial(link = "logit"))
}
