% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampSizeMCTGen.R
\name{sampSizeMCTGen}
\alias{sampSizeMCTGen}
\title{Sample Size Calculations (General Case)}
\usage{
sampSizeMCTGen(family = c("negative binomial", "binomial", "poisson"),
  link = c("log", "logit", "probit", "cauchit", "cloglog",
  "log risk ratio", "risk ratio"), modelPar = NULL, theoResp = NULL,
  doses = NULL, upperN, lowerN = floor(upperN/2), Ntype = c("arm",
  "total"), alRatio = NULL, altModels, alpha = 0.025, power = 0.8,
  sumFct = c("min", "mean", "max"), verbose = FALSE, tol = 0.001)
}
\arguments{
\item{family}{A character string containing the error distribution to be used
in the model.}

\item{link}{A character string for the model link function.}

\item{modelPar}{A numeric vector containing the additional parameters for the
family argument. If the family is negative binomial, the dispersion
parameter should be supplied. If the family is binomial, no model parameter
should be supplied.}

\item{theoResp}{A numerical vector of theoretical response values, on the
transformed scale (e.g. on the log-scale for the negative binomial family).
This should be the same length as the doses argument.}

\item{doses}{A numerical vector of doses, corresponding to the theoretical
response values provided.}

\item{upperN, lowerN}{Upper and lower bound for the power sample size.
\code{lowerN} defaults to \code{floor(upperN/2)}.}

\item{Ntype}{One of "arm", "total", or 'actual". See documentation for
\code{Ntype} in \code{\link[DoseFinding:powMCT]{powMCT}} for descriptions
of "arm" and 'total". For "actual", the nSample should be a numerical
vector containing the actual patient allocation for each dose provided.}

\item{alRatio}{A numeric vector specifying the ratios between the patient
allocation for the specified doses.}

\item{altModels}{An object of class \code{Mods}, defining the mean vectors
under which the power should be calculated.}

\item{alpha}{A numeric value specifying the significance level}

\item{power}{A numeric value specifying the power power of \code{sumFct}}

\item{sumFct}{Either an included character vector or a function that combines
the power values under the different alternative into one value.}

\item{verbose}{A logical specifying whether the patient allocation should be
printed, in addition to the results.}

\item{tol}{A positive numeric value specifying the tolerance level for the
bisection search algorithm. Bisection is stopped if the \code{targFunc}
value is within \code{tol} of power.}
}
\value{
Numeric containing the calculated power values
}
\description{
This function build on the \code{sampSizeMCT} function in the
\code{DoseFinding} package, allowing the procedure to work with the
\code{powMCTGen} function for the general case.
}
\examples{
\donttest{
dose.vec = c(0, 5, 10, 20, 30, 40)
models.full = Mods(doses = dose.vec, linear = NULL,
      sigEmax = rbind(c(9, 2), c(6, 3)),
      emax = 0.8,
      quadratic = -0.02,
      placEff = 0, maxEff = 2)
## Now we can calculate the sample sizes needed in order to achieve a certain power
sampSizeMCTGen("negative binomial", "log", modelPar = 0.1, upperN = 50, Ntype = "arm",
      altModels = models.full, alpha = 0.05, sumFct = "min", power = 0.8)
}
}
