% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMCtrace.R
\name{MCMCtrace}
\alias{MCMCtrace}
\title{Trace and density plots from MCMC output}
\usage{
MCMCtrace(object, params = "all", excl = NULL, ISB = TRUE, iter = 5000,
  gvals = NULL, priors = NULL, pdf = TRUE, open_pdf = TRUE, filename,
  wd = getwd(), type = "both", ind = FALSE)
}
\arguments{
\item{object}{Object containing MCMC output. See DETAILS below.}

\item{params}{Character string (or vector of character strings) denoting parameters of interest.

Default \code{'all'} returns chains for all parameters.}

\item{excl}{Character string (or vector of character strings) denoting parameters to exclude. Used in conjunction with \code{params} argument to select parameters of interest.}

\item{ISB}{Ignore Square Brackets (ISB). Logical specifying whether square brackets should be ignored in the \code{params} and \code{excl} arguments. If \code{TRUE}, square brackets are ignored - input from \code{params} and \code{excl} are otherwise matched exactly. If \code{FALSE}, square brackets are not ignored - input from \code{params} and \code{excl} are matched using grep, which can take arguments in regular expression format. This allows partial names to be used when specifying parameters of interest.}

\item{iter}{Number of iterations to plot for trace and density plots. The default value is 5000, meaning the last 5000 iterations of the chain will be plotted.}

\item{gvals}{Vector containing generating values if simulated data was used to fit model. These values will be plotted as vertical lines on the density plots to compare posterior distributions with the true parameter values used to generate the data. No line will be apparent if the generating value is outside the plotted range of the posterior distribution.}

\item{priors}{Matrix containing random draws from prior distributions corresponding to parameters of interest. If specified, priors are plotted along with posterior density plots. Percent overlap between prior and posterior is also calculated and displayed on each plot. Each column of the matrix represents a prior for a different parameter. Parameters are plotted alphabetically - priors should be sorted accordingly. If \code{priors} contains only one prior and more than one parameter is specified for the \code{params} argument, this prior will be used for all parameters. The number of draws for each prior should equal the number of iterations specified by \code{iter} (or total draws if less than \code{iter}) times the number of chains, though the function will automatically adjust if more or fewer iterations are specified. See DETAILS below.}

\item{pdf}{Logical - if \code{pdf = TRUE} plots will be exported to a pdf.}

\item{open_pdf}{Logical - if \code{open_pdf = TRUE} pdf will open in viewer after being generated.}

\item{filename}{Name of pdf file to be printed. Default is 'MCMCtrace'.}

\item{wd}{Working directory for pdf output. Default is current directory.}

\item{type}{Type of plot to be output. \code{'both'} outputs both trace and density plots, \code{'trace'}
outputs only trace plots, and \code{'density'} outputs only density plots.}

\item{ind}{Logical - if \code{ind = TRUE}, separate density lines will be plotted for each chain. If
\code{ind= FALSE}, one density line will be plotted for all chains.}
}
\description{
Trace and density plots of MCMC chains for specific parameters of interest. Print plots to pdf by default.
}
\section{Details}{

\code{object} argument can be a \code{stanfit} object (\code{rstan} package), an \code{mcmc.list} object (\code{coda} package), an \code{R2jags} model object (\code{R2jags} package), a \code{jagsUI} model object (\code{jagsUI} package), or a matrix containing MCMC chains (each column representing MCMC output for a single parameter, rows representing iterations in the chain). The function automatically detects the object type and proceeds accordingly.

Matrices for the \code{priors} argument can be generated using commands such as rnorm, rgamma, runif, etc. Distributions not supported by base R can be generated by using the appropriate packages. It is important to note that some discrepancies between MCMC samplers and R may exist regarding the parameterization of distributions - one example of this is the use of precision in JAGS but standard deviation in R for the 'second parameter' of the normal distribution. If the number of draws for each prior distribution is greater than the total number used for the density plot (\code{iter} times the number of chains), the function will use a subset of the prior draws. If the number of draws for each prior distribution is less than the total number used for the density plot, the function will resample (with replacement) from the prior to obtain the appropriate number of draws.
}

\examples{
#Load data
data(MCMC_data)

#Traceplots for all 'beta' parameters - a pdf of the traceplots is generated by default
MCMCtrace(MCMC_data, params = 'beta', pdf = FALSE)

#Traceplots (individual density lines for each chain) just for 'beta[1]'
#'params' takes regular expressions when ISB = FALSE, square brackets must be escaped with '\\\\'
MCMCtrace(MCMC_data, params = 'beta\\\\[1\\\\]', ISB = FALSE, ind = TRUE, pdf = FALSE)

#Plot prior on top of posterior and calculate prior/posterior overlap just for 'beta[1]'
#'params' takes regular expressions when ISB = FALSE, square brackets must be escaped with '\\\\'
PR <- rnorm(15000, 0, 32)
MCMCtrace(MCMC_data, params = 'beta\\\\[1\\\\]', ISB = FALSE, priors = PR, pdf = FALSE)

}
