% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_mc.R
\name{sim.mc}
\alias{sim.mc}
\title{Generate a sample of a discrete-state Markov chain}
\usage{
sim.mc(n, P, start = rep(1, ncol(P)))
}
\arguments{
\item{n}{length}

\item{P}{transition matrix (rows are normalized to sum to 1)}

\item{start}{starting distribution (discrete uniform by default)}
}
\description{
Generates a sequence of discrete states from a discrete-time Markov chain with transition matrix P.
}
\examples{
P <- matrix(c(.3,.5,.2,
              .05,.25,.7,
              0,.1,.9), 3, 3, byrow=TRUE)
sim.mc(50, P)
}
