% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TOPSISVector.R
\name{TOPSISVector}
\alias{TOPSISVector}
\title{Implementation of TOPSIS Method for Multi-Criteria Decision Making Problems.}
\usage{
TOPSISVector(decision, weights, cb)
}
\arguments{
\item{decision}{The decision matrix (\emph{m} x \emph{n}) with the values of the \emph{m} alternatives, for the \emph{n} criteria.}

\item{weights}{A vector of length \emph{n}, containing the weights for the criteria. The sum of the weights has to be 1.}

\item{cb}{A vector of length \emph{n}. Each component is either \code{cb(i)='max'} if the \emph{i-th} criterion is benefit or \code{cb(i)='min'} if the \emph{i-th} criterion is a cost.}
}
\value{
\code{TOPSISVector} returns a data frame which contains the score of the R index and the ranking of the alternatives.
}
\description{
The \code{TOPSISVector} function implements the Technique for Order of Preference by Similarity to Ideal Solution (TOPSIS) Method with the vectorial normalization prodecure.
}
\examples{

 d <- matrix(c(6,7,10,2,2.75,3.5),nrow = 3,ncol = 2)
 w <- c(0.5,0.5)
 cb <- c('min','max')
 TOPSISVector(d,w,cb)
}
\references{
Hwang, C.L.; Yoon, K. Multiple Attribute Decision Making. In: Lecture Notes in Economics and Mathematical Systems 186. Springer-Verlag, Berlin, 1981.
}

