% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nodesplit-class.R, R/nodesplit.functions.R
\name{plot.nodesplit}
\alias{plot.nodesplit}
\alias{mb.nodesplit}
\title{Perform node-splitting on a MBNMA time-course network}
\usage{
\method{plot}{nodesplit}(x, plot.type = NULL, params = NULL, ...)

mb.nodesplit(
  network,
  comparisons = mb.nodesplit.comparisons(network),
  nodesplit.parameters = "all",
  fun = tpoly(degree = 1),
  times = NULL,
  lim = "cred",
  ...
)
}
\arguments{
\item{x}{An object of \code{class("nodesplit")}}

\item{plot.type}{A character string that can take the value of \code{"forest"} to plot
only forest plots, \code{"density"} to plot only density plots, or left as \code{NULL} (the
default) to plot both types of plot.}

\item{params}{A character vector corresponding to a time-course parameter(s) for which to plot results.
If left as \code{NULL} (the default), nodes-split results for all time-course parameters will be plotted.}

\item{...}{Arguments to be sent to \code{mb.run()}}

\item{network}{An object of class \code{"mb.network"}.}

\item{comparisons}{A data frame specifying the comparisons to be split (one row per comparison).
The frame has two columns indicating each treatment for each comparison: \code{t1} and \code{t2}.}

\item{nodesplit.parameters}{A character vector of named time-course parameters on which to
node-split (e.g. c("beta.1", "beta.2")). Can use "all" to split on all time-course parameters.}

\item{fun}{An object of class \code{"timefun"} generated (see Details) using any of
\code{tloglin()}, \code{tpoly()}, \code{titp()}, \code{temax()}, \code{tfpoly()}, \code{tspline()} or \code{tuser()}}

\item{times}{A sequence of positive numbers indicating which time points to
predict mean responses for (or at which to conduct a node-split if used with \code{mb.nodesplit()})}

\item{lim}{Specifies calculation of either 95\% credible intervals (\code{lim="cred"}) or 95\% prediction intervals (\code{lim="pred"}).}
}
\value{
Plots the desired graph(s) and returns an object (or list of objects if
\code{plot.type=NULL}) of \code{class(c("gg", "ggplot"))}, which can be edited using \code{ggplot} commands.

A an object of \code{class("mb.nodesplit")} that is a list containing elements
\code{d.X.Y} (treatment 1 = \code{X}, treatment 2 = \code{Y}). Each element (corresponding to each
comparison) contains additional numbered elements corresponding to each parameter in the
time-course function on which node splitting was performed. These elements then contain:
\itemize{
\item \verb{overlap matrix} MCMC results for the difference between direct and indirect evidence
\item \code{p.values} Bayesian p-value for the test of consistency between direct and indirect evidence
\item \code{quantiles}
\item \code{forest.plot}
\item \code{density.plot}
\item \code{direct} MCMC results for the direct evidence
\item \code{indirect} MCMC results for the indirect evidence
}
}
\description{
Within a MBNMA time-course network, split contributions into direct and indirect evidence and test
for consistency between them. Closed loops of treatments in which it is possible to test for
consistency are those in which direct and indirect evidence are available from independent sources
van Valkenhoef \insertCite{vanvalkenhoef2016;textual}{MBNMAtime}.
}
\details{
The S3 method \code{plot()} on an \code{mb.nodesplit} object generates either
forest plots of posterior medians and 95\\\% credible intervals, or density plots
of posterior densities for direct and indirect evidence.

Note that by specifying the \code{times} argument a user can perform a node-split of treatment
effects at a specific time-point. This will give the treatment effect for both direct, indirect, and
MBNMA estimates at this time point.
}
\section{Functions}{
\itemize{
\item \code{plot(nodesplit)}: Plot outputs from nodesplit models

}}
\examples{
\donttest{
# Create mb.network object
painnet <- mb.network(osteopain)

# Identify comparisons informed by direct and indirect evidence
splits <- mb.nodesplit.comparisons(painnet)

# Fit a log-linear time-course MBNMA (takes a while to run)
result <- mb.nodesplit(painnet, comparisons=splits, nodesplit.parameters="all",
  fun=tloglin(pool.rate="rel", method.rate="common"),
  rho="dunif(0,1)", covar="varadj"
  )

# Fit an emax time-course MBNMA with a node-split on emax parameters only
result <- mb.nodesplit(painnet, comparisons=splits, nodesplit.parameters="emax",
  fun=temax(pool.emax="rel", method.emax="common",
    pool.et50="rel", method.et50="common"))

# Inspect results
print(result)
summary(result)

# Plot results
plot(result)
}
}
\references{
\insertAllCited
}
