% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare.functions.R
\name{add_index}
\alias{add_index}
\title{Add follow-up time and arm indices to a dataset}
\usage{
add_index(data.ab, reference = 1)
}
\arguments{
\item{data.ab}{A data frame of arm-level data in "long" format containing the columns:
\itemize{
\item \code{studyID} Study identifiers
\item \code{time} Numeric data indicating follow-up times
\item \code{treatment} Treatment identifiers (can be numeric, factor or character)
\item \code{class} An optional column indicating a particular class code. Treatments with the same identifier
must also have the same class code.
}}

\item{reference}{A number or character (depending on the format of \code{treatment} within \code{data.ab})
indicating the reference treatment in the network (i.e. those for which estimated relative treatment
effects estimated by the model will be compared to).}
}
\value{
A data frame similar to \code{data.ab} but with additional columns:
\itemize{
\item \code{arm} Arm identifiers coded for each study
\item \code{fupcount} Follow-up identifiers coded for each study
\item \code{fups} The total number of follow-up measurements in each study
\item \code{narm} The total number of arms in each study
}

If \code{treatment} or \code{class} are non-numeric or non-sequential (i.e. with missing numeric codes),
treatments/classes in the returned data frame will be numbered and recoded to enforce sequential
numbering (a warning will be shown stating this).
}
\description{
Adds follow-up time (\code{fups}, \code{fupcount}) and arm (\code{arms}, \code{narms}) indices to a dataset.
}
\examples{
# Add indices to osteoarthritis pain dataset
data.ab <- add_index(osteopain)

# Add indices to dataset using different network reference treatment
data.ab <- add_index(osteopain, reference=3)
}
