% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.jags.R
\name{write.timecourse}
\alias{write.timecourse}
\title{Adds sections of JAGS code for an MBNMA model that correspond to alpha
parameters}
\usage{
write.timecourse(model, fun, intercept, positive.scale)
}
\arguments{
\item{model}{A character string representing the MBNMA model in JAGS code}

\item{fun}{An object of class \code{"timefun"} generated (see Details) using any of
\code{tloglin()}, \code{tpoly()}, \code{texp()}, \code{temax()}, \code{tfpoly()}, \code{tspline()} or \code{tuser()}}

\item{intercept}{A boolean object that indicates whether an intercept is to
be included in the model. Can be used to imply whether mean responses in
data are change from baseline (\code{FALSE}) or not (setting it to \code{FALSE}
removes the intercept, \code{alpha}, from the model).}

\item{positive.scale}{A boolean object that indicates whether all continuous
mean responses (y) are positive and therefore whether the baseline response
should be given a prior that constrains it to be positive (e.g. for scales that cannot be <0).}

\item{timecourse}{A character object that contains JAGS code for the
time-course component of the model}
}
\value{
A list of named elements: \code{model} is a character vector of JAGS MBNMA
model code that includes alpha parameter components of the model
\code{timecourse} is a character object that contains JAGS code for the
time-course component of the model, for which alpha will be indexed
correctly
}
\description{
Adds sections of JAGS code for an MBNMA model that correspond to alpha
parameters
}
