% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.functions.R
\name{devplot}
\alias{devplot}
\title{Plot deviance contributions from an MBNMA model}
\usage{
devplot(
  mbnma,
  plot.type = "box",
  facet = TRUE,
  dev.type = "resdev",
  n.iter = mbnma$BUGSoutput$n.iter/2,
  n.thin = mbnma$BUGSoutput$n.thin,
  ...
)
}
\arguments{
\item{mbnma}{An S3 object of class \code{"mbnma"} generated by running
a dose-response MBNMA model}

\item{plot.type}{Deviances can be plotted either as scatter points (\code{"scatter"})
or as boxplots (\code{"box"})}

\item{facet}{A boolean object that indicates whether or not to facet (by agent for \code{MBNMAdose}
and by treatment for \code{MBNMAtime})}

\item{dev.type}{\emph{STILL IN DEVELOPMENT FOR MBNMAdose!} Deviances to plot - can be either residual
deviances (\code{"resdev"}, the default) or deviances (\code{"dev"})}

\item{n.iter}{number of total iterations per chain (including burn in;
    default: 2000)}

\item{n.thin}{thinning rate. Must be a positive integer.  Set
    \code{n.thin} > 1 to save memory and computation time if
    \code{n.iter} is large.  Default is \code{max(1, floor(n.chains *
    (n.iter-n.burnin) / 1000))} which will only thin if there are at
    least 2000 simulations.}

\item{...}{Arguments to be sent to \code{ggplot2::geom_point()} or \code{ggplot2::geom_boxplot}}
}
\value{
Generates a plot of deviance contributions and returns a list containing the
plot (as an object of \code{class(c("gg", "ggplot"))}), and a data.frame of posterior mean
deviance/residual deviance contributions for each observation.
}
\description{
Plot deviance contributions from an MBNMA model
}
\details{
Deviances should only be plotted for models that have converged successfully. If deviance
contributions have not been monitored in \code{mbnma$parameters.to.save} then additional
iterations will have to be run to get results for these.

For \code{MBNMAtime}, deviance contributions cannot be calculated for models with a multivariate likelihood (i.e.
those that account for correlation between observations) because the covariance matrix in these
models is treated as unknown (if \code{rho = "estimate"}) and deviance contributions will be correlated.
}
\examples{
\donttest{
# Using the triptans data
network <- mbnma.network(triptans)

# Run an Emax dose-response MBNMA and predict responses
emax <- mbnma.run(network, fun=demax(), method="random")

# Plot deviances
devplot(emax)

# Plot deviances using boxplots
devplot(emax, plot.type="box")

# Plot deviances on a single scatter plot (not facetted by agent)
devplot(emax, facet=FALSE, plot.type="scatter")

# A data frame of deviance contributions can be obtained from the object
#returned by `devplot`
devs <- devplot(emax)
head(devs$dev.data)

# Other deviance contributions not currently implemented but in future
#it will be possible to plot them like so
#devplot(emax, dev.type="dev")
}

}
