  \name{testclass_simul}
\alias{testclass_simul}

\title{Evaluating a classification method based on simulated data}
\usage{
testclass_simul(datalist,nlearn=100,classifier,ncomp=0:3,nbgene=NULL,
varsel=NULL,fold=10,...)
}
\arguments{
  \item{datalist}{A list of niter simulated data sets as generated by the functions \code{simuldata_list} and \code{simuldatacluster_list} (see \code{\link{simulate}}).}
  \item{nlearn}{The number of observations to be included in the learning data set. It must be smaller than
		the total number of observations of the data sets.}
  \item{classifier}{The function used to construct a classifier. The function must have the same structure as \code{\link{plsrf_xz_pv}}.}
  \item{ncomp}{The candidate numbers of PLS components (if PLS dimension reduction is used).}
 \item{nbgene}{The number of genes to use for classifier construction. Default is \code{nbgene=NULL}, corresponding
		to all genes.}
  \item{varsel}{A niter x p matrix giving the indices of the genes ordered
by the chosen gene selection criterion. For example, the element in the first
row and the first column is the index of the gene that is ranked best using in the first simulation iteration.}
  \item{fold}{The number of folds for the pre-validation step, if any. See Boulesteix et al (2008) for more details. Default is \code{fold=10}.}
 \item{...}{Other arguments to be passed to the function \code{cforest_control} from the \code{party} package
or to the function \code{svm} from the package \code{e1071}, depending on the specified classifier.}
}
\description{
This function evaluates classifiers built using microarray data and/or clinical predictors, based on 
simulated data generated using the functions \code{simuldata_list} and \code{simuldatacluster_list} 
(see \code{\link{simulate}}). 
}

\details{
See Boulesteix et al (2008).
}

\value{
	\item{error}{A numeric vector of length \code{niter} giving the misclassification rate for each iteration.}
	\item{bestncomp}{A numeric vector of length \code{niter} giving the best number of (pre-validated) PLS components, as obtained using the model selection method based on the out-of-bag error by Boulesteix et al (returned only for the classifiers \code{\link{plsrf_xz_pv}}, \code{\link{plsrf_xz}}, \code{\link{plsrf_x_pv}}, \code{\link{plsrf_x}}).}
	\item{OOB}{A list of length \code{niter}, whose elements are numeric vectors of the same length as \code{ncomp} giving the
out-of-bag error of the forest constructed with the corresponding number of (pre-validated) PLS components
(returned only for the classifiers \code{\link{plsrf_xz_pv}}, \code{\link{plsrf_xz}}, \code{\link{plsrf_x_pv}}, \code{\link{plsrf_x}}, \code{\link{rf_z}}. For \code{\link{rf_z}}, no model selection is performed: \code{OOB} is just the out-of-bag error of the 
constructed forest.) }
    }

\references{
Boulesteix AL, Porzelius C, Daumer M, 2008.
Microarray-based classification and clinical predictors: On combined classifiers and additional predictive value. Bioinformatics 24:1698-1706.
}

\author{
  Anne-Laure Boulesteix (\url{http://www.slcmsr.net/boulesteix})
}

\seealso{\code{\link{testclass}}, \code{\link{plsrf_xz_pv}}, \code{\link{simulate}},
\code{\link{plsrf_xz_pv}}, \code{\link{plsrf_x_pv}}, \code{\link{plsrf_xz}}, \code{\link{plsrf_x}}, 
\code{\link{rf_z}}, \code{\link{svm_x}}, \code{\link{logistic_z}}.}



\examples{
# load MAclinical library
# library(MAclinical)

# Generating 3 simulated data sets
my.data<-simuldata_list(niter=3,n=100,p=150,psig=10,q=5,muX=2,muZ=1)

# Perform prediction of the 60 last observations using the first 40 observations, 
# based on PLS (without pre-validation) and random forests

testclass_simul(my.data,nlearn=40,classifier=plsrf_xz)

}

\keyword{htest}
