% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stepAIC_BIC.R
\name{plot.drop_term}
\alias{plot.drop_term}
\title{drop_term plot method}
\usage{
\method{plot}{drop_term}(
  x,
  ...,
  horiz = TRUE,
  las = ifelse(horiz, 1, 2),
  col = c("#DF536B", "#2297E6"),
  border = c("#DF536B", "#2297E6"),
  show.model = TRUE
)
}
\arguments{
\item{x}{An object of class \code{"drop_term"} generated by tither \code{drop_term} or \code{add_term}}

\item{..., horiz}{arguments past on to \code{graphics::barplot}}

\item{las}{graphics parameter}

\item{col, border}{\code{barplot} fill and border colour(s) for positive and negative changes to the criterion, respectively}

\item{show.model}{logical: should the model itself be displayed?}
}
\value{
\code{x} invisibly
}
\description{
drop_term plot method
}
\examples{
boston_quad <- lm(medv ~ . + (rm + tax + lstat)^2 + poly(rm, 2) + 
         poly(tax, 2) + poly(lstat, 2), Boston)
dboston_quad <- drop_term(boston_quad, k = "bic")
plot(dboston_quad)
plot(dboston_quad, horiz = FALSE)
}
